<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
require_once 'db.php';

try {
    // Fetch only category names
    $result = $conn->query("SELECT category FROM blog_category WHERE Delete_status = 0 ORDER BY category ASC");
    
    $categories = [];
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row['category'];
    }
    
    echo json_encode($categories);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to fetch categories']);
}

$conn->close();
?>